-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/help_style.lua" );

TableInfoFont = {
  standardFont,
  14,
  AquaColor
};

EligibleFont = {
  standardFont,
  14,
  AquaColor
};

EligibleAsteriskFont = {
  standardFont,
  12,
  AquaColor
};


ConnectingToServerFont = {
	standardFont,
	14,
	AquaColor
};

TableHeaderFont = {
  standardFont,
  18,
  AquaColor
};

ScoreInfoFont = {
  standardFont,
  14,
  AquaColor
};


ScoreFont = {
  standardFont,
  14,
  AquaColor
};

RankFont = {
  standardFont,
  14,
  AquaColor
};

RankFont2 = {
  standardFont,
  14,
  GreenFitness
};



kScoreRowSpace = 25;
kRowY = 45;
kNumberX = 37;
kNameX = 52;
kNameY = kRowY-3;
kScoreX = 335;
kP1X = kNumberX + 1;

kNameW = 250
kNameH = 21

eLocalView=0;
eRequestingCategories=1;
eRequestingScores=2;
eSubmitting=3;
eGlobalView=4;
eError=5;

function UpdateButtons()
	local state = GetState();
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	EnableWindow("view",false);
	EnableWindow("viewlocal",false);
	EnableWindow("submit",false);
	EnableWindow("categoryleft",false);
	EnableWindow("categoryright",false);
	
	if (state==eLocalView) then
		local eligibleScore;

		if fullHS then
			EnableWindow("moreinfo",true);
		else 
			EnableWindow("moreinfo",false);
		end
		
		if not localHS then
			EnableWindow("view",true);

			if (ScoreAvailable()) then
				EnableWindow("submit",true);
			end
		end
	elseif (state == eGlobalView) then
		EnableWindow("viewlocal",true);
		EnableWindow("categoryleft",true);
		EnableWindow("categoryright",true);
	elseif (state == eError) then
		EnableWindow("viewlocal",true);
	end

end


function MakeMedalButton()
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);
				
	if not anonHS then
		return Group
		{
			SBButton
			{
				x=550,
				y=kMax-127,
				name="back",
				
				icon="assets/images/ui/buttons/icon/icontrophy",
				command =
					function()
						DoModal("scripts/medals.lua");
					end
			};
			
			Text
			{
				font = SmallFont,
				x=550,
				y=kMax-127+30,
				label="trophies",
				flags = kHAlignCenter + kVAlignCenter,
			};
		};
	else
		return Group
		{
		};
	end
end

MakeDialog
{
	-- Name the modal dialog
	name="hiscorescreen",
	Bitmap
	{
		image="images/backgrounds/bgpopup01.png",
		
		Bitmap
		{
			image="images/ui/common/popup01",
			x=kCenter,
			y=kCenter,
		};

		HiscoreWindow
		{
			x=0,y=0,h=kMax,w=kMax,

			Text
			{
				font = BigPopupFont,
				name = "header",
				x=0,y=55,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "highscoreheader"
			};
			Bitmap
			{
				image="images/ui/buttons/box01",
				x=kCenter,
				y=kTextHeaderY+27,
					
				Text
				{
					font = {standardFont,18,TittleAqua},
					name = "gamemode",
					x=0,y=0,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "#GAMEMODE"
				};
			};
			SetStyle(FitnessButtonStyleTittleFlatBlueTxInside),
			SBButton
			{
				x=110,	
				y=kMax-95,
				name="view",
				label="viewglobal",
			};
			Text
			{
				font = NormalHelpFont3,
				name = "local",
				x=115,y=167,w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "localhighscores"
			};


			Text
			{
				font = NormalHelpFont3,
				name = "global",
				x=115,y=167,w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "globalhighscores"
			};

			Bitmap
			{
				x = 100,
				y = 185,
				image="images/ui/buttons/box04",
				name="leftpanel",

				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "topplayers"
				};
				Text
				{
					font = ScoreFont,
					x=290,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "hiscore.label.score"
				};
				Text
				{
					font = ScoreFont,
					name = "1",
					x=0,y=kRowY,w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "1."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_1",
					x=kP1X,y=kRowY
				};

				Text
				{
					font = ScoreFont,
					name = "name1",
					x=kNameX,y=kNameY,w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score1",
					x=0,y=kRowY,w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "2."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_2",
					x=kP1X,y=kRowY+(1*kScoreRowSpace)
				};


				Text
				{
					font = ScoreFont,
					name = "name2",
					x=kNameX,y=kNameY+(1*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "3."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_3",
					x=kP1X,y=kRowY+(2*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name3",
					x=kNameX,y=kNameY+(2*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "4."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_4",
					x=kP1X,y=kRowY+(3*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name4",
					x=kNameX,y=kNameY+(3*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "5."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_5",
					x=kP1X,y=kRowY+(4*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name5",
					x=kNameX,y=kNameY+(4*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "6."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_6",
					x=kP1X,y=kRowY+(5*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name6",
					x=kNameX,y=kNameY+(5*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "7."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_7",
					x=kP1X,y=kRowY+(6*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name7",
					x=kNameX,y=kNameY+(6*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "8."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_8",
					x=kP1X,y=kRowY+(7*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name8",
					x=kNameX,y=kNameY+(7*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "9."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_9",
					x=kP1X,y=kRowY+(8*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name9",
					x=kNameX,y=kNameY+(8*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "10."
				};

				Bitmap
				{
					image = "images/hiscore/p1icon",
					name = "p1_10",
					x=kP1X,y=kRowY+(9*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name10",
					x=kNameX,y=kNameY+(9*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

			};

	

			Text
			{
				font = ScoreInfoFont,
				name = "yourrankglobalinfo",
				x=480,y=188,w=200,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "ui.dialog.highscores.global.complete_info.message"
			};

			Text
			{
				font = RankFont,
				name = "yourrank",
				x=10,y=85,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "yourrank"
			};

			Text
			{
				font = RankFont2,
				name = "congratulations",
				x=90,y=169,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "congratshighscore"
			};

			Text
			{
				font = RankFont,
				name = "dnq",
				x=10,y=50,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "scorednq"
			};


			Text
			{
				font = ScoreInfoFont,
				name = "info",
				x=480,y=188,w=200,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "ui.dialog.highscores.global.complete_info.message"
			};


			Text
			{
				font = EligibleFont,
				name = "eligible",
				x=480,y=360,w=kMax-60,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "eligible"
			};

			SetStyle(FitnessButtonStyleTittleXLBlueTxInside),
			SBButton
			{
				x=500,
				y=230,
				name="moreinfo",
				label="moreinfo",
				command =
					function()
						DoModal("scripts/hiscoreinfo.lua");
					end

			};

			SBButton
			{
				x=500,
				y=350,
				name="submit",
				label="submit",
	--			command =
	--				function()
	--					DoModal("scripts/hiscoresubmit.lua");
	--				end
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=190,y=kCenter,w=258,h=130,
				flags = kHAlignLeft + kVAlignCenter,
				label = "connectingtoserver"
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=485,y=362,w=258,h=130,
				flags = kHAlignCenter + kVAlignCenter,
			};



			Text
			{
				font = ScoreFont,
				name = "category",
				x=163,y=194,w=208,h=40,
				flags = kHAlignCenter + kVAlignTop,
			};

			SetStyle(FitnessButtonStyleTittleSmallBlue),

			SBButton
			{
				name="gamemodeleft",
				x=kCenter -150,
				y=107,
				label = "ui.label.blank",
				icon="assets/images/ui/buttons/icon/iconback",
			};

			SBButton
			{
				icon="assets/images/ui/buttons/icon/iconplay",
				label = "ui.label.blank",
				name="gamemoderight",
				x=kCenter + 150,
				y=107,
				hflip=true,
			};

			Button
			{
				Bitmap
				{
					x=0,
					y=0,
					image="assets/images/ui/buttons/icon/iconplay",
					hflip=true,
					scale = 0.6,
				},
				--graphics = LeftButtonGraphics,
				name="categoryleft",
				x=160,
				y=188,
				scale = 0.6
			};

			SBButton
			{
				Bitmap
				{
					x=0,
					y=0,
					image="assets/images/ui/buttons/icon/iconplay",
					scale = 0.6,
				},
				--graphics = LeftButtonGraphics,
				name="categoryright",
				x=330,
				y=188,
				scale = 0.6,
				hflip=true,
			};
--scrollbar
			Bitmap
			{
				x = 457,
				y = 200,
				image="assets/images/ui/buttons/soundbar01",
				name = "scrollbar",
				rotate=true,
			};
			Button
			{
				graphics = LeftButtonGraphics,
				rotate=true,
				name="scrollup",
				x=452,
				y=215,
				scale = 0.4,
				Bitmap
				{
					x=3,
					y=1,
					image="assets/images/metamap/right_arrow",
					scale = 0.4,
					rotate=true,
					hflip=true,
				},
			};

			Button
			{
				graphics = LeftButtonGraphics,
				rotate=true,
				hflip=true,
				name="scrolldown",
				x=452,
				y=450,
				scale = 0.4,
				Bitmap
				{
					x=2,
					y=1,
					image="assets/images/metamap/right_arrow",
					scale = 0.4,
					rotate=true,
				},
			};

			SetStyle(FitnessButtonStyleTittleSmallBlue),
			SBButton
			{
				x=630,
				y=kMax-127,
				name="back",
				
				icon="assets/images/ui/buttons/icon/iconback",
				command =
					function()
						PopModal("hiscorescreen"); -- take off high score menu, restart game loop
					end
			};
			Text
			{
				font = SmallFont,
				x=630,
				y=kMax-127+30,
				label="common.back.label",
				flags = kHAlignCenter + kVAlignCenter,
			};
			
			MakeMedalButton();
			
--			SBButton
--			{
--				x=550,
--				y=kMax-127,
--				name="back",
--				
--				icon="assets/images/ui/buttons/icon/icontrophy",
--				command =
--					function()
--						DoModal("scripts/medals.lua");
--					end
--			};
			
--			Text
--			{
--				font = SmallFont,
--				x=550,
--				y=kMax-127+30,
--				label="trophies",
--				flags = kHAlignCenter + kVAlignCenter,
--			};
			SetStyle(FitnessButtonStyleTittleFlatBlueTxInside),
			SBButton
			{
				x=110,	
				y=kMax-95,
				name="viewlocal",
				label="viewlocal",
			};
			
		}
	}
}